' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion. 
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data
Imports Microsoft.VisualBasic

Public Class BlogManager

  ''' <summary>
  ''' Ukryj konstruktor, aby unikn tworzenia egzemplarzy klasy BlogManager.
  ''' </summary>
  Private Sub New()
  End Sub

  ''' <summary>
  ''' Zwraca ostatnich 15 (lub mniej, jeli nie ma tylu) wpisw do blogu z bazy danych wywoujc metod z klasy <see cref="BlogManagerDB" />.
  ''' </summary>
  ''' <returns>DataSet z wpisami w blogu.</returns>
  Public Shared Function GetBlogEntries() As DataSet
    Return BlogManagerDB.GetBlogEntries()
  End Function

  ''' <summary>
  ''' Zwraca wpisy w blogu opublikowane w okrelonej kategorii wywoujc metod z klasy <see cref="BlogManagerDB" />.
  ''' </summary>
  ''' <param name="categoryId">Identyfikator kategorii w bazie danych that dla ktrej maj by zwrcone wpisy w blogu.</param>
  ''' <returns>DataSet z wpisami w blogu.</returns>
  Public Shared Function GetBlogEntries(ByVal categoryId As Integer) As DataSet
    Return BlogManagerDB.GetBlogEntries(categoryId)
  End Function

  ''' <summary>
  ''' Zwraca wpisy w blogu opublikowane w okrelonym przedziale czasu wywoujc metod z klasy <see cref="BlogManagerDB" />.
  ''' </summary>
  ''' <param name="startDate">Pocztkowa data przedziau czasu, z ktrego wpisy w blogu maj by zwrcone.</param>
  ''' <param name="endDate">Kocowa data przedziau czasu, dla ktrego wpisy w blogu maj by zwrcone.</param>
  ''' <returns>DataSet z wpisami w blogu.</returns>
  ''' <exception cref="NotSupportedException">Zgaszany, gdy uytkownik Zgaszany t metod nie wystpuje w roli Administratora.</exception>
  Public Shared Function GetBlogEntries(ByVal startDate As DateTime, ByVal endDate As DateTime) As DataSet
    Return BlogManagerDB.GetBlogEntries(startDate, endDate)
  End Function

  ''' <summary>
  ''' Zwraca pojedynczy obiekt BlogEntry z bazy danych na podstawie jego identyfikatora wywoujc metod z klasy <see cref="BlogManagerDB" />.
  ''' </summary>
  ''' <param name="blogEntryId">Identyfikator wpisu w bazie danych.</param>
  ''' <returns>Egzemplarz klasy BlogEntry jeli znaleziono pozycj lub <see langword="Nothing" /> w przeciwnym razie.</returns>
  ''' <exception cref="NotSupportedException">Zgaszany, gdy uytkownik wywoujcy t metod nie wystpuje w roli Administratora.</exception>
  Public Shared Function GetBlogEntry(ByVal blogEntryId As Integer) As BlogEntry
    If HttpContext.Current.User.IsInRole("Administrator") Then
      Return BlogManagerDB.GetBlogEntry(blogEntryId)
    Else
      Throw New NotSupportedException("Wywoywanie metody GetBlogEntry jest niedozwolone jeli " & _
          "nie jeste czonkiem grupy Administrator.")
    End If
  End Function

  ''' <summary>
  ''' Zapisuje wpis z bloga w bazie danych wywoujc metod z klasy <see cref="BlogManagerDB" />
  ''' </summary>
  ''' <param name="myBlogEntry">Obiekt BlogEntry do zapisania.</param>
  ''' <exception cref="NotSupportedException">Zgaszany, gdy uytkownik wywoujcy t metod nie wystpuje w roli Administratora.</exception>
  Public Shared Sub SaveBlogEntry(ByVal myBlogEntry As BlogEntry)
    If HttpContext.Current.User.IsInRole("Administrator") Then
      BlogManagerDB.SaveBlogEntry(myBlogEntry)
    Else
      Throw New NotSupportedException("Wywoywanie metody SaveBlogEntry jest niedozwolone jeli " & _
          "nie jeste czonkiem grupy Administrator.")
    End If
  End Sub

  ''' <summary>
  ''' Pobiera list dostpnych kategorii z bazy danych wywoujc metod z klasy <see cref="BlogManagerDB" />.
  ''' </summary>
  Public Shared Function GetCategories() As DataSet
    Return BlogManagerDB.GetCategories()
  End Function

End Class
